	function [S1, S2] = LATTICE_2_H_Z(Zodd, Podd, Zeven, Peven, wT)
	
	% 	Determine the reflectances (frequency responses) of the two  
	%	branches in a lattice wave digital (LWD) filter pair at the 
	%	angular frequencies wT. Parallel resonance circuits.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2009-08-09
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	exp_wT = exp(j*wT);
	S1 = 1*ones(1,length(wT));
	for n = 1:length(Podd)
		S1 = -S1.*(exp_wT- Podd(n))./(1- Podd(n)*exp_wT);
	end
	S2 = 1*ones(1,length(wT));
	for n = 1:length(Peven)
		S2 = -S2.*(exp_wT-Peven(n))./(1-Peven(n)*exp_wT);
	end
